#import( class , HashArray )
#import( class , CDB_Ram )
#import( class , CS_ParseMail )
#import( class , CS_Bayes )
#import( class , CS_BayesWord )
#import( class , CS_FileSystem )


#include "lib.cs"

CS_ADMIN_SCRIPT this = new CS_ADMIN_SCRIPT($_this);

int Main(CAdminRequest pRequest, CAdminResponse pResponse)
{
 
   //CR_QUERY_NSHL_BAYES_AUTO
   if (pRequest->GetRecordCount() > 0)
   {

    CS_FileSystem sys = new CS_FileSystem();
    HashArray fields;
    CS_Bayes bayes = this->GetDBBayes();

    for (int c = 0; c < pRequest->GetRecordCount(); c++)
    {
      fields =  pRequest->GetRow();
      

    if (bayes == NULL || fields == NULL)
        return CONTINUE_SCRIPT;

   

     string key  = fields->GetS("c1");
     string tipo = fields->GetS("c2");
     string todb = fields->GetS("c3");
	
     CDB_Ram db_bayes = NULL;
     string source;
     if (tipo == "ham")
     {
	db_bayes = bayes->GetDBRam("ham");
	source = "/quarantine/ham/";
     }
     if (tipo == "spam")
     {
	db_bayes = bayes->GetDBRam("spam");
	source = "/quarantine/spam/";
     }
     if (tipo == "neutral")
     {
	db_bayes = bayes->GetDBRam("neutral");
	source = "/quarantine/neutral/";
     }
     if (tipo == "learn")
     {
	db_bayes = bayes->GetDBRam("learn");
	source = "/quarantine/learn/";
     }

    if (db_bayes == NULL)
        return CONTINUE_SCRIPT;

    
      if (todb == "delete")
      {

	sys->UnLink(sys->AppPath() + source + key + ".eml");
	db_bayes->Delete(key);
        continue;
      }
   
      CS_ParseMail email = new CS_ParseMail();
      CS_BayesWord words = new CS_BayesWord();
   
      if (email->LoadFromFile(sys->AppPath() + source + key + ".eml") == true)
      {
	if (email->Parse() == true)
	{
	  if (words->Elaborate(email) == true)
	  {
	     
            if (todb == "ham")
		bayes->PopolateDB(words,2); // CBayes::THIS_IS_HAM
	    else
	        bayes->PopolateDB(words,1); // CBayes::THIS_IS_SPAM

  	    sys->UnLink(sys->AppPath() + source + key + ".eml");
	    db_bayes->Delete(key);
	  }
	}
      } else {
	      db_bayes->Delete(key);
	     }

     delete email;
     delete words;
     email = NULL;
     words = NULL;

  }
   CDB_Ram db_bayes = NULL;
   db_bayes = bayes->GetDBRam("ham");
   db_bayes->Save();

   db_bayes = bayes->GetDBRam("spam");
   db_bayes->Save();

   db_bayes = bayes->GetDBRam("neutral");
   db_bayes->Save();

   db_bayes = bayes->GetDBRam("learn");
   db_bayes->Save();

   bayes->RemoveNeutral(true);
   delete sys;
   pResponse->Send(pRequest->GetCmd(),CR_ACK);
 }

   
return CONTINUE_SCRIPT;

}